unit EnumObjectFamily;

interface
uses SysUtils, Variants, Classes, Controls, TypInfo;

procedure EnumClassFamily( aClass: TClass; Lines: TStrings );

implementation

// =============================================================
//     VMT
class function GetVMTEnd(AClass: TClass): Pointer;
var  Start, Current, Finish, VMTEnd : Pointer;
begin
  //       VMT
  VMTEnd  := Pointer(Integer(aClass) + vmtSelfPtr);
  //    ,   VMT
  Start   := Pointer(Integer(aClass) + vmtIntfTable);
  Finish  := Pointer(Integer(aClass) + vmtClassName);
  //     
  Current := Start;
  while Integer(Current) <= Integer(Finish)
  do begin
     if (Integer(Current^) > Integer(VMTEnd))
     then begin
        //       
        //      VMTEnd, 
        //    VMT    
        // 
        Integer(VMTEnd) := Integer(Current^);
     end;
     //    
     Current := Pointer(Integer(Current) + SizeOF(Pointer));
  end;
  Result := VMTEnd;
end;
// =============================================================
//       VMT
procedure ShowTabName (pAddres, PItem  : pointer;
                       Lines: TStrings; TabName : string);
begin
  if (Integer(pAddres^) >= Integer(PItem)) and
     (Integer(pAddres^) <= Integer(PItem) + 3)
  then begin
   if Integer(pAddres^) = Integer(PItem)
   then Lines.Add(TabName);
   if Integer(pAddres^) = (Integer(PItem) + 1)
   then Lines.Add(TabName + ' + 1 ');
   if Integer(pAddres^) = (Integer(PItem) + 2)
   then Lines.Add(TabName + ' + 2 ');
   if Integer(pAddres^) = (Integer(PItem) + 3)
   then Lines.Add(TabName + ' + 3 ');
  end;
end;
// =============================================================
//     
function ByteToHexStr (RqByte : byte): string;
const HexCharsArray : array[0..15] of char =
     ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
begin
 //        
 Result := HexCharsArray[$0F and RqByte];
 //   ,    ,  
 Result := HexCharsArray[($F0 and RqByte) shr 4] + Result;
end;
// =============================================================
//    
function IntToDumpStr (RqDump : pointer) : string;
type Dump = packed record
  B1,B2,B3,B4 : byte;
end;
var pDump : ^Dump;
    HexStr, CharStr : string;
begin
   pDump := RqDump;
   with pDump^ do
   begin
     HexStr  := ByteToHexStr(B1);
     CharStr := Char(B1);
     HexStr  := HexStr  + ByteToHexStr(B2);
     CharStr := CharStr + Char(B2);
     HexStr  := HexStr  + ByteToHexStr(B3);
     CharStr := CharStr + Char(B3);
     HexStr  := HexStr  + ByteToHexStr(B4);
     CharStr := CharStr + Char(B4);
   end;
   Result := 'Dump : ' + HexStr + ' | ' + CharStr;
end;
// =============================================================
//   VMT
procedure EnumVTM (aClass: TClass; Lines: TStrings);
//   VTM.     
//     .
type TTabItem = packed record
     pAddress : Pointer;         //  
end;

//    system.pas  VTM
const LenNameVTM = 19;
//    system.pas  VTM
const NameVMT : array[1..LenNameVTM] of string[17] = (
'SelfPtr',           'IntfTable',         'AutoTable',   'InitTable',
'TypeInfo',          'FieldTable',        'MethodTable', 'DynamicTable',
'ClassName',         'InstanceSize',      'Parent',      'SafeCallException',
'AfterConstruction', 'BeforeDestruction', 'Dispatch',    'DefaultHandler',
'NewInstance',       'FreeInstance',      'Destroy');
//   
var pBegVTM      : pointer;     //    VTM
    pItemVTM     : ^TTabItem;   //     
    pVMTEnd      : pointer;     //    VTM
    Num          : Word;        //  
    WStr         : string;
begin
  Lines.Add('');
  Lines.Add(' VTM (Virtual method table)');
  //       VTM
  pBegVTM  := Pointer(Integer(aClass) + vmtSelfPtr);
  pItemVTM := pBegVTM;
  Lines.Add(Format('  VMT : %p', [pItemVTM]));
  pVMTEnd := GetVMTEnd(aClass);
  Lines.Add(Format('   VMT : %p', [pVMTEnd]));
  Num := 1;        //    
  repeat
    if Num <= LenNameVTM
    then begin  //    
       with pItemVTM^ do
       Lines.Add(Format('TabAddr : %p  Addr : %p    %d. %s',
                       [ pItemVTM, pAddress, Num, NameVMT[Num] ]));
    end
    else begin  //     
       //    
       if Num = (LenNameVTM + 1)
       then Lines.Add('  Virtual ');

       ShowTabName(Pointer(Integer(aClass) + vmtIntfTable),
                   pItemVTM, Lines, '  IntfTable');

       ShowTabName(Pointer(Integer(aClass) + vmtAutoTable),
                   pItemVTM, Lines, '  AutoTable');

       ShowTabName(Pointer(Integer(aClass) + vmtInitTable),
                   pItemVTM, Lines, '  InitTable');

       ShowTabName(Pointer(Integer(aClass) + vmtTypeInfo),
                   pItemVTM, Lines, '  TypeInfo');

       ShowTabName(Pointer(Integer(aClass) + vmtFieldTable),
                   pItemVTM, Lines, '  FieldTable');

       ShowTabName(Pointer(Integer(aClass) + vmtMethodTable),
                   pItemVTM, Lines, '  Published ');

       ShowTabName(Pointer(Integer(aClass) + vmtDynamicTable),
                   pItemVTM, Lines, '  Dynamic ');

       ShowTabName(Pointer(Integer(aClass) + vmtClassName),
                   pItemVTM, Lines, '  ClassName');

       //    
       with pItemVTM^ do
       WStr := Format('TabAddr : %p  Addr : %p    %d.',
                       [ pItemVTM,  pAddress, Num ]);
       //   
       WStr := WStr + '  ' + IntToDumpStr(pItemVTM);
       Lines.Add(WStr);
    end;
    Inc(Num);
    //      
    pItemVTM := Pointer(Integer(pItemVTM) + SizeOF(Pointer));
    //         
    until (Integer(pItemVTM) > Integer(pVMTEnd)) or (Num > 512);
   // until (Num > 64);
end;

// =============================================================
//       Dynamic 
procedure EnumDynamicMethod (aClass: TClass; Lines: TStrings);
//  Dynamic    
type TDyna1Item = packed record
         IInd   : SmallInt;     //  
end;
//  Dynamic      
type TDyna2Item = packed record
      pAddress  : Pointer;      //    
end;
var pBegDYNA     : pointer;     //    
    NumItems     : Word;        //    
    pDyna1Item   : ^TDyna1Item; //     
    pDyna2Item   : ^TDyna2Item; //     
    Num          : Word;        //    
    p            : pointer;     //  
    pp           : ^Pointer;    //    
begin
  //      Dynamic 
  pp := Pointer(Integer(aClass) + vmtDynamicTable);  pBegDYNA := pp^;
  Lines.Add(Format('  Dynamic  : %p', [pBegDYNA]));
  if pBegDYNA <> nil then
  begin
     Lines.Add('    ');
     //   (word)       
     NumItems := PWord(pBegDYNA)^;
     Lines.Add(Format('   Dynamic  :  %d', [NumItems]));
     Lines.Add('    Dynamic  :');
     //   (pDyna1Item)     , 
     //      (2 )   Dynamic .
     pDyna1Item := Pointer(Integer(pBegDYNA) + SizeOF(Word));
     for Num := 1 to NumItems do
     begin
       with pDyna1Item^ do
            Lines.Add(format( '  %d. Index : %d', [Num,  IInd]));
       //   (pMetItem)     
       pDyna1Item := Pointer(Integer(pDyna1Item) + SizeOF(pDyna1Item^.IInd));
     end;
     Lines.Add('    Dynamic  :');
     p := pDyna1Item;  pDyna2Item := p;
     for Num := 1 to NumItems do
     begin
       with pDyna2Item^ do
            Lines.Add(format( '  %d. Addr : %p', [Num,  pAddress]));
       //   (pMetItem)     
       pDyna2Item := Pointer(Integer(pDyna2Item) + SizeOF(Pointer));
     end;
  end;
end;

// =============================================================
//       Published 
procedure EnumPublishedMethod (aClass: TClass; Lines: TStrings);
//  Published 
type TMetItem = packed record
     ILen     : Word;          //     
     pAddress : Pointer;       //   
     MName    : ShortString;   //  
end;
var pBegVTM   : pointer;       //    
    NumItems  : Word;          //    
    pMetItem  : ^TMetItem;     //      
    Num       : Word;          //  
    pp        : ^pointer;      //    

begin
  pp := Pointer(Integer(aClass) + vmtMethodtable);  pBegVTM := pp^;
  Lines.Add(Format('  Published  : %p', [pBegVTM]));
  if pBegVTM <> nil then
  begin
     Lines.Add('   Published ');
     //   (word)       
     NumItems := PWord(pBegVTM)^;
     Lines.Add(Format('   published  : %d', [NumItems]));

     //   (pMetItem)     , 
     //      (2 )    (MetTab).
     pMetItem := Pointer(Integer(pBegVTM) + 2);
     for Num := 1 to NumItems do
     begin
       with pMetItem^ do
            Lines.Add(format( '  %d. Len : %d ; Addr : %p ; Name : %s',
                               [Num,  ILen,      pAddress,   MName]));
       //   (pMetItem)    
       pMetItem := Pointer(Integer(pMetItem) + pMetItem^.ILen);
     end;
     Lines.Add('');
  end;
end;

procedure EnumClassFamily(aClass: TClass; Lines: TStrings);
begin
  if aClass = nil then Exit; //  
     // *********
     Lines.Add('');
     if aClass.ClassParent <> nil
     then begin
       Lines.Add('==========================================');
       Lines.Add(Format('%s = class ( %s )',
                        [aClass.Classname, aClass.ClassParent.ClassName]));
     end
     else begin
       Lines.Add('==========================================');
       Lines.Add(Format('%s = class ()', [aClass.Classname]));
     end;
     Lines.Add('------------------------------------------');
    //   Published methods
    EnumPublishedMethod (aClass, Lines);
    //   Dynamic methods
    EnumDynamicMethod (aClass, Lines);
    //   VTM
    EnumVTM (aClass, Lines);
    Lines.Add('');
  //  *********
  //      
  EnumClassFamily(aClass.ClassParent,Lines );
end;

end.
